<?php
/**
 * Plugin Name: SmartIt enhancements
 * Description: Adds primary category
 * Part generated by grok,GPT5
 * Version:     1.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Check if WooCommerce is active
if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
    return;
}

/**
 * Filter the main term used in WooCommerce breadcrumbs. *
 */
// https://github.com/woocommerce/woocommerce/issues/31411#issuecomment-2468525696

function si_woocommerce_breadcrumb_main_term($main_term, $terms) {
    // Only proceed on single product pages
    if (!is_product() || !is_singular('product')) {
        return $main_term;
    }

    // Get the stored primary category ID
    $primary_cat_id = get_post_meta(get_the_ID(), 'SI_PRIMARY_CATEGORYID', true);
    if (!$primary_cat_id || !is_numeric($primary_cat_id)) {
        return $main_term;
    }

    $primary_cat_id = (int) $primary_cat_id;

    // Find the primary term in the list of assigned terms
    foreach ($terms as $term) {
        if ($term->term_id === $primary_cat_id) {
            return $term; // Return the primary term
        }
    }

    // Fallback: return default if primary not found or not in assigned terms
    return $main_term;
}
add_filter('woocommerce_breadcrumb_main_term', 'si_woocommerce_breadcrumb_main_term', 10, 3);


// https://github.com/Yoast/wordpress-seo/issues/4528#issuecomment-232263154
class SI_wc_product_post_type_link_product_cat {

    public function __construct() {
        add_action('wc_product_post_type_link_product_cat', [$this, 'wc_product_post_type_link_product_cat'], 10, 3);
    }

    public function wc_product_post_type_link_product_cat($main_term, $terms, $post) {
        // Get the stored primary category ID
        $primary_cat_id = get_post_meta($post->ID, 'SI_PRIMARY_CATEGORYID', true);
        if (!$primary_cat_id || !is_numeric($primary_cat_id)) {
            return $main_term;
        }

        $primary_cat_id = (int) $primary_cat_id;

        // Find the primary term in the list of assigned terms
        foreach ($terms as $term) {
            if ($term->term_id === $primary_cat_id) {
                return $term; // Return the primary term
            }
        }

        // Fallback: return default if primary not found or not in assigned terms
        return $main_term;        
        
    }
}


new SI_wc_product_post_type_link_product_cat();
